local SpriteLib = require "modSprite"
local AnimTimer = require "timer"

local this = {}
this.x = 0
this.y = 100
this.animating = false
this.head = nil
this.torso = nil
this.legs = nil
this.isactive = false
this.torsoOffset = 1
this.torsoOffsets = {{0,0},{0,1},{-1,1},{-1,2},{-2,2},{-2,1},{-2,0},{-2,1},{-1,1},{-1,2},{0,2},{0,1}}
this.prevTorsoXOff = 0

function this.Init()
	this.head = SpriteLib.CreateSprite("sans/faces/normal", this.x, this.y, false)
	this.torso = SpriteLib.CreateSprite("sans/body", this.x, this.y, false)
	this.legs = SpriteLib.CreateSprite("sans/feet", this.x, this.y, false)
	this.StartAnim()
	this.isactive = true
end

function this.Redraw()
	this.head.Create()
	this.torso.Create()
	this.legs.Create()
end

function this.StopAnim()
	AnimTimer.StopTimer("torso")
	this.animating = false
	this.torsoOffset = 1
	this.prevTorsoXOff = this.torsoOffsets[this.torsoOffset][1]
end

function this.StartAnim()
	local ttimer = AnimTimer.CreateTimer("torso",0.1,true)
	function ttimer.OnComplete()
		this.torsoOffset = this.torsoOffset + 1
		if(this.torsoOffset > 12) then
			this.torsoOffset = 1
		end
	end
	this.animating = true
end

function this.Update()
	AnimTimer.UpdateTimers()

	this.legs.MoveTo(this.x, this.y)
	this.head.MoveTo(this.x + this.prevTorsoXOff, this.torso.y + 44)
	this.torso.MoveTo(this.x + this.torsoOffsets[this.torsoOffset][1], this.legs.y + 47 + this.torsoOffsets[this.torsoOffset][2])
	this.prevTorsoXOff = this.torsoOffsets[this.torsoOffset][1]
end

function this.Remove()
	this.StopAnim()
	this.legs.Remove()
	this.head.Remove()
	this.torso.Remove()
	this.isactive = false
end

return this